

products = [
    {
        brand_name: "Moda Rapido",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2378362/2018/6/9/270e0a7e-365b-4640-9433-b269c60bf3061528527188563-Moda-Rapido-Men-Maroon-Printed-Round-Neck-T-shirt-3811528527-1.jpg",
        T_shirt_name: "Printed Round Neck T-shirt",
        price: 421,
        discount: 35,
        oldprice: 649,
    },
    {
        brand_name: "HRX",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2314372/2018/6/19/29e8ddfd-6f5f-43fd-8b71-dfa8ac6cef681529385860869-HRX-by-Hrithik-Roshan-Men-Charcoal-Grey-Slim-Advanced-Rapid--1.jpg",
        T_shirt_name: "Ultralyte Men Running T-shirt",
        price: 800,
        discount: 20,
        oldprice: 1000,

    },

    {
        brand_name: "Moda Rapido",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2378414/2018/2/8/11518071262125-Moda-Rapido-Men-Navy-Blue-Striped-Round-Neck-T-shirt-3641518071261992-1.jpg",
        T_shirt_name: "Printed Round neck T-shirt",
        price: 421,
        discount: 35,
        oldprice: 649,

    },
    {
        brand_name: "H&M",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/productimage/2021/2/25/dcd80c17-5db3-4176-a0f3-62b74ce386df1614246409273-1.jpg",
        T_shirt_name: "Round neck T-shirt Regular fit",
        price: 350,
        discount: 50,
        oldprice: 700,

    },
    {
        brand_name: "Roadster",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2169170/2018/1/31/11517402469341-Roadster-Men-Black-Colourblocked-Round-Neck-T-shirt-6121517402469142-1.jpg",
        T_shirt_name: "Brush Printed T-shirt",
        price: 419,
        discount: 50,
        oldprice: 839,

    },
    {
        brand_name: "HRX",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2314433/2018/4/11/11523427507742-HRX-by-Hrithik-Roshan-Men-Tshirts-2051523427507608-4.jpg",
        T_shirt_name: "Slim rapid dry Raglan T-shirt",
        price: 449,
        discount: 10,
        oldprice: 499,

    },
    {
        brand_name: "Nautica",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13573298/2021/5/17/b71cc490-1c1d-464a-846a-0461dc22f9101621250551546-Nautica-Men-Tshirts-2981621250550824-1.jpg",
        T_shirt_name: "Striped polo collar T-shirt",
        price: 1399,
        discount: 30,
        oldprice: 1999,

    },
    {
        brand_name: "DILLINGER",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/11067722/2019/12/10/1290831c-0862-4b6a-8eee-41a6cad1b1e01575972511857-DILLINGER-Men-Tshirts-3141575972509288-1.jpg",
        T_shirt_name: "coloured round neck T-shirt",
        price: 449,
        discount: 10,
        oldprice: 499,

    },
    {
        brand_name: "Roadster",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/8807157/2019/2/28/c421d8d6-fcf6-44b0-bf34-d3d7690505051551343695119-Roadster-Men-Black-Colourblocked-Round-Neck-T-shirt-91915513-1.jpg",
        T_shirt_name: "Striped Round neck T-shirt",
        price: 449,
        discount: 10,
        oldprice: 499,

    },
    {
        brand_name: "HRX",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2314400/2018/6/19/82353ec3-9ebf-421e-bb0f-c897166555641529389688071-HRX-by-Hrithik-Roshan-Men-Navy-Advanced-Rapid-Dry-Round-Neck-1.jpg",
        T_shirt_name: "RAPID-DRY Round neck T-shirt",
        price: 449,
        discount: 10,
        oldprice: 499,

    },
    {
        brand_name: "FIDO DIDO",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2476463/2018/2/10/11518244710081-FIDO-DIDO-Men-Mustard-Printed-Polo-Collar-T-shirt-5511518244709858-1.jpg",
        T_shirt_name: "Solid Polo Collar T-shirt",
        price: 629,
        discount: 10,
        oldprice: 699,
    },
    {
        brand_name: "Levis",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13298386/2021/3/3/a45e9273-cb98-407b-8bf3-7c1287716e2b1614762063196-Levis-Men-Red--Navy-Blue-Colourblocked-Round-Neck-T-shirt-wi-1.jpg",
        T_shirt_name: "coloured Round neck T-shirt",
        price: 1199,
        discount: 20,
        oldprice: 1499,

    },
    {
        brand_name: "Levis",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13298380/2021/1/27/0dd95d61-be30-4eea-9fc1-0373cb7cc38a1611751095466-Levis-Men-Tshirts-4771611751093290-1.jpg",
        T_shirt_name: "Printed round neck T-shirt",
        price: 800,
        discount: 20,
        oldprice: 999,

    },
    {
        brand_name: "WROGN",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/1894413/2017/6/20/11497943671766-WROGN-Men-Grey-Melange-Self-Design-Round-Neck-T-shirt-881497943671356-1.jpg",
        T_shirt_name: "Self Design round neck T-shirt",
        price: 792,
        discount: 10,
        oldprice: 879,

    },
    {
        brand_name: "WROGN",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/10188253/2019/9/26/1c589968-d8a0-43e6-acc6-8a22494c85a81569502754494-WROGN-Men-Off-White-Printed-Hood-T-shirt-1061569502752645-1.jpg",
        T_shirt_name: "Printed Hood T-shirt",
        price: 629,
        discount: 10,
        oldprice: 699,

    },
    {
        brand_name: "Tommy Hilfiger",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14188518/2021/5/25/337fbcd2-a36a-4e30-8848-5a58e68491b11621921852238TommyHilfigerMenPinkSolidPureCottonPoloCollarT-shirt1.jpg",
        T_shirt_name: "Sollid Polo collar T-shirt",
        price: 2399,
        discount: 20,
        oldprice: 2999,

    },
    {
        brand_name: "Tommy Hilfiger",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14588376/2021/7/9/f42894bd-1db4-44c3-a291-8a74b058cea51625834541471-Tommy-Hilfiger-Men-Blue-Polo-Collar-Slim-Fit-T-shirt-8501625-1.jpg",
        T_shirt_name: "cotton Custom fit T-shirt",
        price: 2999,
        discount: 25,
        oldprice: 3999,

    },
    {
        brand_name: "Tommy Hilfiger",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14589080/2021/7/6/ccfbc98b-aff9-4421-a62b-0b6ed69ae30c1625565725104-Tommy-Hilfiger-Men-Tshirts-971625565724537-1.jpg",
        T_shirt_name: "Men Embroiderd T-shirt",
        price: 1599,
        discount: 50,
        oldprice: 3199,

    },
    {
        brand_name: "WROGN",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/2478310/2018/3/27/11522132732327-WROGN-Men-Tshirts-2331522132732139-1.jpg",
        T_shirt_name: "Dyed Round Neck T-shirt",
        price: 699,
        discount: 50,
        oldprice: 1399,
    },
    {
        brand_name: "Puma",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/12352660/2020/9/21/b64ec2e4-8aa4-40ae-8b0d-d4946d71d6e41600683357698JacketsPumaMenShortsPumaMenShortsPumaMenShortsPumaMenSweatsh1.jpg",
        T_shirt_name: "Striped Henley Neck T-shirt",
        price: 449,
        discount: 50,
        oldprice: 899,

    },
    {
        brand_name: "Puma",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13802728/2021/4/8/e9ebda03-a8bd-458b-8e66-db7485634df91617874077486-Puma-Men-Tshirts-8601617874076356-1.jpg",
        T_shirt_name: "Slim Fit Printed T-shirt",
        price: 1374,
        discount: 25,
        oldprice: 1899,

    },
    {
        brand_name: "Puma",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14284654/2021/7/13/9d06e424-a09d-4c07-b070-a5bbb86a09b01626176462803-Puma-Men-Tshirts-1891626176461066-1.jpg",
        T_shirt_name: "Yellow & Teal Printed T-shirt",
        price: 1299,
        discount: 25,
        oldprice: 1799,

    },
    {
        brand_name: "Puma",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13802728/2021/4/8/e9ebda03-a8bd-458b-8e66-db7485634df91617874077486-Puma-Men-Tshirts-8601617874076356-1.jpg",
        T_shirt_name: "Men Printed T-shirt",
        price: 899,
        discount: 25,
        oldprice: 1199,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/12635590/2020/11/3/bef08c65-bcf3-40e4-978b-2e65ac8a61cc1604397319402-ADIDAS-Men-Tshirts-7741604397318122-1.jpg",
        T_shirt_name: "Runner LOng Sleeves T-shirt",
        price: 899,
        discount: 25,
        oldprice: 1199,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/12946124/2020/12/1/e49160b8-9fef-4f55-b0c4-fac4978cd3c01606797938415-ADIDAS-Men-Neon-Orange-Solid-ADI-Runner-T-shirt-631160679793-1.jpg",
        T_shirt_name: "ADI Runner T-shirt",
        price: 899,
        discount: 25,
        oldprice: 1199,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13743438/2021/3/12/a09b1d7e-0099-4018-b0bc-15f0da23ad971615528296786TshirtsADIDASOriginalsMenTshirtsADIDASMenTshirtsADIDASOrigin1.jpg",
        T_shirt_name: "Men Club RIb Polo T-shirt",
        price: 899,
        discount: 25,
        oldprice: 1199,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/12618162/2020/12/5/3a97a155-947b-411f-ad10-b5160427984c1607156459914ShortsADIDASMenShortsADIDASMenShortsAlcisMenShortsAlcisMenTi1.jpg",
        T_shirt_name: "heat ready 1 polo tennis T-shirt",
        price: 899,
        discount: 25,
        oldprice: 1199,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13536554/2021/5/18/00a649b5-183d-4b70-aa5e-284e67ef7e9b1621329562382LevisWomenNavyBluePinkPrintedRoundNeckT-shirtTshirtsRoadster1.jpg",
        T_shirt_name: "X DISNEY T-shirt",
        price: 899,
        discount: 50,
        oldprice: 1799,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/12906542/2020/12/5/0aa14b3d-4bc6-4c65-ac84-044263402ebe1607156496063ShortsADIDASMenShortsADIDASMenShortsAlcisMenShortsAlcisMenTi1.jpg",
        T_shirt_name: "Hypereal Circled Slogan T-shirt",
        price: 1049,
        discount: 50,
        oldprice: 2099,

    },
    {
        brand_name: "ADIDAS",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13536486/2021/5/12/f161efb6-4e6c-400c-8b40-90901f1683f71620809767954PumaMenWhiteClassicsEmbroSolidRoundNeckT-shirtTshirtsPumaMen1.jpg",
        T_shirt_name: "Unisex Giant Logo Q1 T-shirt",
        price: 1719,
        discount: 10,
        oldprice: 1899,

    },
    {
        brand_name: "Levis",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13549952/2021/2/25/56166ecc-fd21-4b64-a227-73f6c43763521614232994206-Levis-Men-Tshirts-8561614232992866-1.jpg",
        T_shirt_name: "Self Design round neck T-shirt",
        price: 1599,
        discount: 20,
        oldprice: 1999,
    },
    {
        brand_name: "Levis",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/13549978/2021/2/25/74b6e8dd-245a-4a93-89a1-629134e24a9c1614233100712-Levis-Men-Tshirts-2221614233099358-1.jpg",
        T_shirt_name: "Self Design round neck T-shirt",
        price: 1599,
        discount: 20,
        oldprice: 1999,
    },
    {
        brand_name: "Tommy Hilfiger",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14589112/2021/7/9/59f4ec4a-2f6d-4641-b482-f03e1575a09a1625806643754-Tommy-Hilfiger-Men-Tshirts-9771625806643261-1.jpg",
        T_shirt_name: "Self Design round neck T-shirt",
        price: 2499,
        discount: 0,
        oldprice: 2499,
    },
    {
        brand_name: "Tommy Hilfiger",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/14589112/2021/7/9/59f4ec4a-2f6d-4641-b482-f03e1575a09a1625806643754-Tommy-Hilfiger-Men-Tshirts-9771625806643261-1.jpg",
        T_shirt_name: "Self Design round neck T-shirt",
        price: 2499,
        discount: 0,
        oldprice: 2499,
    },
    {
        brand_name: "WROGN",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/1729573/2017/2/23/11487841881751-WROGN-Off-White--Green-Printed-T-Shirt-8371487841881408-1.jpg",
        T_shirt_name: "Prnted Round Neck T-shirt",
        price: 2499,
        discount: 0,
        oldprice: 2499,
    },
    {
        brand_name: "HRX",
        img: "https://assets.myntassets.com/f_webp,dpr_1.5,q_60,w_210,c_limit,fl_progressive/assets/images/10565566/2020/2/4/98edd42d-583b-44ff-9d90-4e67e5a3522f1580809674758-HRX-by-Hrithik-Roshan-Men-Black-Solid-Running-T-shirt-163158-1.jpg",
        T_shirt_name: "Prnted Round Neck T-shirt",
        price: 2499,
        discount: 0,
        oldprice: 2499,
    },

]



if (JSON.parse(localStorage.getItem("products")) == null) {
    localStorage.setItem("products", JSON.stringify(products))
}

function showProducts(d) {
    let products = d;

    products.forEach(function (el) {
        appendProduct(el);
    })
}

function appendProduct(el) {
    let catalogue = document.getElementById('products-right');

    let div = document.createElement("div")

    // console.log(el);

    div.addEventListener("click", function () {
        localStorage.setItem("clickedProduct", JSON.stringify(el))
    })

    div.innerHTML = `<a class="each-product" href="moda.html"
              ><div>
                <img
                  src= ${el.img}
                  alt=""
                />
                <div class="brand">${el.brand_name}</div>
                <div class="name">${el.T_shirt_name}</div>
                <div class="price">
                 Rs. ${Math.ceil(el.oldprice * (100 - el.discount) / 100)} <span class="line-through">Rs. ${el.oldprice}</span>
                  <span class="discount">(${el.discount}% OFF)</span>
                </div>
              </div></a
            >`
    // console.log(div)



    catalogue.append(div)
}

showProducts(JSON.parse(localStorage.getItem("products")))



function sort() {
    let menu = document.getElementById("type");
    menu.addEventListener("change", generateData);

    function generateData(event) {
        if (menu.value == '1') {
            let products = JSON.parse(localStorage.getItem("products"))
            let catalogue = document.getElementById('products-right');
            catalogue.innerHTML = null;

            products = products.sort(function (a, b) {
                return b.price - a.price
            });

            showProducts(products);
        } else if (menu.value == '2') {
            let products = JSON.parse(localStorage.getItem("products"))
            let catalogue = document.getElementById('products-right');
            catalogue.innerHTML = null;

            products = products.sort(function (a, b) {
                return a.price - b.price
            });

            showProducts(products);
        } else if (menu.value == '3') {
            let products = JSON.parse(localStorage.getItem("products"))
            let catalogue = document.getElementById('products-right');
            catalogue.innerHTML = null;

            products = products.sort(function (a, b) {
                return b.discount - a.discount
            });

            showProducts(products);
        }
        else if (menu.value == '4') {
            let products = JSON.parse(localStorage.getItem("products"))
            let catalogue = document.getElementById('products-right');
            catalogue.innerHTML = null;

            showProducts(products);
        }
    }
}
sort();

function filter(x) {
    let products = JSON.parse(localStorage.getItem("products"))

    products = products.filter(function (el) {
        return el.brand_name == x;
    })

    let catalogue = document.getElementById('products-right');
    catalogue.innerHTML = null;
    showProducts(products);
}

function priceFilter(x, y) {
    let products = JSON.parse(localStorage.getItem("products"))

    products = products.filter(function (el) {
        return el.price < x && el.price > y;
    })

    let catalogue = document.getElementById('products-right');
    catalogue.innerHTML = null;
    showProducts(products);
}